/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import java.util.Arrays;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MapHelper {
    public static final boolean MAP_ATLASES = PlatformHelper.isModLoaded("map_atlases");

    @Nullable
    public static class_22 getMapData(class_1799 stack, class_1937 level, @Nullable class_1657 player) {
        class_22 data = class_1806.method_8001((class_1799)stack, (class_1937)level);
        if (data == null && MAP_ATLASES && player != null) {
            data = MapAtlasCompat.getSavedDataFromAtlas(stack, level, player);
        }
        return data;
    }

    public static Integer getMapId(class_1799 stack, class_1657 player, Object data) {
        Integer i = class_1806.method_8003((class_1799)stack);
        if (i == null && MAP_ATLASES) {
            i = MapAtlasCompat.getMapIdFromAtlas(stack, player.field_6002, data);
        }
        return i;
    }

    public static void addVanillaDecorations(class_1799 stack, class_2338 pos, class_20.class_21 type, int mapColor) {
        class_22.method_110((class_1799)stack, (class_2338)pos, (String)"+", (class_20.class_21)type);
        if (mapColor != 0) {
            class_2487 com = stack.method_7911("display");
            com.method_10569("MapColor", mapColor);
        }
    }

    public static void addDecorationToMap(class_1799 stack, class_2338 pos, MapDecorationType<?, ?> type, int mapColor) {
        class_2499 tags;
        if (stack.method_7985() && stack.method_7969().method_10573("CustomDecorations", 9)) {
            tags = stack.method_7969().method_10554("CustomDecorations", 10);
        } else {
            tags = new class_2499();
            stack.method_7959("CustomDecorations", (class_2520)tags);
        }
        class_2487 tag = new class_2487();
        tag.method_10582("type", Utils.getID(type).toString());
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("z", pos.method_10260());
        tags.add((Object)tag);
        if (mapColor != 0) {
            class_2487 com = stack.method_7911("display");
            com.method_10569("MapColor", mapColor);
        }
    }

    public static void addDecorationToMap(class_1799 stack, class_2338 pos, class_2960 id, int mapColor) {
        Optional<class_20.class_21> opt;
        if (id.method_12836().equals("minecraft") && (opt = Arrays.stream(class_20.class_21.values()).filter(t -> t.toString().toLowerCase().equals(id.method_12832())).findFirst()).isPresent()) {
            MapHelper.addVanillaDecorations(stack, pos, opt.get(), mapColor);
            return;
        }
        MapDecorationType<? extends CustomMapDecoration, ?> type = MapDecorationRegistry.get(id.toString());
        if (type != null) {
            MapHelper.addDecorationToMap(stack, pos, type, mapColor);
        } else {
            MapHelper.addVanillaDecorations(stack, pos, class_20.class_21.field_84, mapColor);
        }
    }

    public static boolean toggleMarkersAtPos(class_1937 level, class_2338 pos, class_1799 stack, @Nullable class_1657 player) {
        class_22 data = MapHelper.getMapData(stack, level, player);
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            return expandedMapData.toggleCustomDecoration((class_1936)level, pos);
        }
        return false;
    }

    public static boolean removeAllCustomMarkers(class_1937 level, class_1799 stack, @Nullable class_1657 player) {
        class_22 data = MapHelper.getMapData(stack, level, player);
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            if (!level.field_9236) {
                expandedMapData.resetCustomDecoration();
                return true;
            }
        }
        return false;
    }
}

